/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.autoworkstations.auto_grindstone;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.autoworkstations.auto_grindstone.AutoGrindstoneScreenHandler;
import uk.co.cablepost.autoworkstations.util.TextUtil;

public class AutoGrindstoneBlockEntity
extends class_2586
implements class_1278,
class_3908 {
    public static int INVENTORY_SIZE = 5;
    public static int SLOT_EXP_BOTTLE = 0;
    public static int SLOT_EMPTY_BOTTLE = 1;
    public static int SLOT_ITEM_IN = 2;
    public static int SLOT_ITEM_ADD = 3;
    public static int SLOT_ITEM_OUT = 4;
    public static int MODE_GRIND = 0;
    public static int MODE_DISENCHANT = 1;
    public static int PROPERTY_DELEGATE_SIZE = 7;
    public int xpFillBottleMaxProgress = 20;
    public int processProgress;
    public int maxProcessProgress = 60;
    public int mode = MODE_GRIND;
    public class_1799 result = null;
    public class_1799 lastInputStack = null;
    public class_1799 lastAdditionStack = null;
    public int lastMode = -1;
    public Random random;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)INVENTORY_SIZE, (Object)class_1799.field_8037);
    int xpFillBottleProgress;
    float expTank;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return AutoGrindstoneBlockEntity.this.xpFillBottleProgress;
                }
                case 1: {
                    return AutoGrindstoneBlockEntity.this.xpFillBottleMaxProgress;
                }
                case 2: {
                    return (int)Math.floor(AutoGrindstoneBlockEntity.this.expTank);
                }
                case 3: {
                    return (int)Math.floor(AutoGrindstoneBlockEntity.this.expTank % 1.0f * 100.0f);
                }
                case 4: {
                    return AutoGrindstoneBlockEntity.this.processProgress;
                }
                case 5: {
                    return AutoGrindstoneBlockEntity.this.maxProcessProgress;
                }
                case 6: {
                    return AutoGrindstoneBlockEntity.this.mode;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 6) {
                AutoGrindstoneBlockEntity.this.updateResult();
                AutoGrindstoneBlockEntity.this.mode = value;
            }
        }

        public int method_17389() {
            return PROPERTY_DELEGATE_SIZE;
        }
    };

    public AutoGrindstoneBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.random = new Random();
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, AutoGrindstoneBlockEntity blockEntity) {
        if (blockEntity.processProgress > 0) {
            ++blockEntity.processProgress;
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, AutoGrindstoneBlockEntity blockEntity) {
        boolean toMarkDirty = false;
        class_1799 emptyBottlesStack = (class_1799)blockEntity.inventory.get(SLOT_EMPTY_BOTTLE);
        class_1799 expBottlesStack = (class_1799)blockEntity.inventory.get(SLOT_EXP_BOTTLE);
        if (blockEntity.expTank >= 8.0f && !emptyBottlesStack.method_7960() && emptyBottlesStack.method_31574(class_1802.field_8469) && (expBottlesStack.method_7960() || expBottlesStack.method_31574(class_1802.field_8287) && expBottlesStack.method_7947() < expBottlesStack.method_7914())) {
            ++blockEntity.xpFillBottleProgress;
            if (blockEntity.xpFillBottleProgress >= blockEntity.xpFillBottleMaxProgress) {
                blockEntity.expTank -= 8.0f;
                emptyBottlesStack.method_7934(1);
                if (expBottlesStack.method_7960()) {
                    expBottlesStack = new class_1799((class_1935)class_1802.field_8287);
                } else {
                    expBottlesStack.method_7933(1);
                }
                blockEntity.inventory.set(SLOT_EXP_BOTTLE, (Object)expBottlesStack);
                blockEntity.xpFillBottleProgress = 0;
                toMarkDirty = true;
            }
        } else {
            blockEntity.xpFillBottleProgress = 0;
        }
        class_1799 input = blockEntity.method_5438(SLOT_ITEM_IN);
        class_1799 addition = blockEntity.method_5438(SLOT_ITEM_ADD);
        if (blockEntity.lastMode != blockEntity.mode || blockEntity.lastInputStack == null || blockEntity.lastInputStack.method_7960() != input.method_7960() || blockEntity.lastInputStack.method_7909() != input.method_7909() || blockEntity.lastInputStack.method_7947() != input.method_7947() || blockEntity.lastAdditionStack == null || blockEntity.lastAdditionStack.method_7960() != addition.method_7960() || blockEntity.lastAdditionStack.method_7909() != addition.method_7909() || blockEntity.lastAdditionStack.method_7947() != addition.method_7947() || blockEntity.result == null) {
            blockEntity.lastInputStack = input.method_7972();
            blockEntity.lastAdditionStack = addition.method_7972();
            blockEntity.lastMode = blockEntity.mode;
            class_1799 resultBefore = blockEntity.result == null ? null : blockEntity.result.method_7972();
            blockEntity.updateResult();
            if (resultBefore == null || blockEntity.result.method_7960() != resultBefore.method_7960() || blockEntity.result.method_7909() != resultBefore.method_7909() || resultBefore.method_7919() != blockEntity.result.method_7919() || !Objects.equals(resultBefore.method_57824(class_9334.field_49639), blockEntity.result.method_57824(class_9334.field_49639))) {
                blockEntity.processProgress = 0;
            }
        }
        if (!blockEntity.result.method_7960() && blockEntity.method_5438(SLOT_ITEM_OUT).method_7960()) {
            ++blockEntity.processProgress;
            if (blockEntity.processProgress == 1) {
                toMarkDirty = true;
            }
            if (blockEntity.processProgress == blockEntity.maxProcessProgress - 15) {
                world.method_8396(null, pos, class_3417.field_16865, class_3419.field_15245, 0.3f, world.field_9229.method_43057() * 0.1f + 0.9f);
            }
            if (blockEntity.processProgress >= blockEntity.maxProcessProgress) {
                blockEntity.doProcess();
                blockEntity.processProgress = 0;
                toMarkDirty = true;
            }
        } else {
            blockEntity.processProgress = 0;
        }
        if (toMarkDirty) {
            blockEntity.method_5431();
        }
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        super.method_11014(nbt, wrapperLookup);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)wrapperLookup);
        this.xpFillBottleProgress = nbt.method_10550("XpFillBottleProgress");
        this.xpFillBottleMaxProgress = nbt.method_10550("XpFillBottleMaxProgress");
        if (this.xpFillBottleMaxProgress == 0) {
            this.xpFillBottleMaxProgress = 20;
        }
        this.expTank = nbt.method_10583("ExpTank");
        this.processProgress = nbt.method_10550("ProcessProgress");
        this.maxProcessProgress = nbt.method_10550("MaxProcessProgress");
        if (this.maxProcessProgress == 0) {
            this.maxProcessProgress = 60;
        }
        this.mode = nbt.method_10550("Mode");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        super.method_11007(nbt, wrapperLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)wrapperLookup);
        nbt.method_10569("XpFillBottleProgress", this.xpFillBottleProgress);
        nbt.method_10569("XpFillBottleMaxProgress", this.xpFillBottleMaxProgress);
        nbt.method_10548("ExpTank", this.expTank);
        nbt.method_10569("ProcessProgress", this.processProgress);
        nbt.method_10569("MaxProcessProgress", this.maxProcessProgress);
        nbt.method_10569("Mode", this.mode);
    }

    public void doProcess() {
        this.addExperienceLevels();
        this.method_5447(SLOT_ITEM_IN, class_1799.field_8037);
        this.method_5447(SLOT_ITEM_ADD, class_1799.field_8037);
        this.method_5447(SLOT_ITEM_OUT, this.result.method_7972());
    }

    public class_2561 method_5476() {
        return TextUtil.translatableText(this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new AutoGrindstoneScreenHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.inventory.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir == class_2350.field_11036 || dir == class_2350.field_11033) {
            return slot == SLOT_ITEM_IN && this.method_5438(slot).method_7960();
        }
        if (stack.method_31574(class_1802.field_8469)) {
            return slot == SLOT_EMPTY_BOTTLE;
        }
        if (stack.method_31574(class_1802.field_8287)) {
            return slot == SLOT_EXP_BOTTLE;
        }
        return slot == SLOT_ITEM_ADD;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == SLOT_EXP_BOTTLE || slot == SLOT_ITEM_OUT;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.inventory) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        if (amount == ((class_1799)this.inventory.get(slot)).method_7947()) {
            return this.method_5441(slot);
        }
        class_1799 toRet = ((class_1799)this.inventory.get(slot)).method_7972();
        ((class_1799)this.inventory.get(slot)).method_7934(amount);
        toRet.method_7939(amount);
        return toRet;
    }

    public class_1799 method_5441(int slot) {
        class_1799 toRet = ((class_1799)this.inventory.get(slot)).method_7972();
        this.inventory.set(slot, (Object)class_1799.field_8037);
        return toRet;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void method_5431() {
        boolean serverSide = this.method_11002() && !this.method_10997().method_8608();
        super.method_5431();
        if (serverSide) {
            ((class_3218)this.field_11863).method_14178().method_14128(this.method_11016());
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public void addExperienceLevels() {
        this.expTank += (float)this.getExperience(this.method_10997());
    }

    private int getExperience(class_1937 world) {
        int i = 0;
        i += this.getExperience((class_1799)this.inventory.get(SLOT_ITEM_IN));
        if ((i += this.getExperience((class_1799)this.inventory.get(SLOT_ITEM_ADD))) > 0) {
            int j = (int)Math.ceil((double)i / 2.0);
            return j + world.field_9229.method_43048(j);
        }
        return 0;
    }

    private int getExperience(class_1799 stack) {
        int i = 0;
        class_9304 itemEnchantmentsComponent = class_1890.method_57532((class_1799)stack);
        for (Object2IntMap.Entry e : itemEnchantmentsComponent.method_57539()) {
            class_1887 enchantment = (class_1887)((class_6880)e.getKey()).comp_349();
            int j = e.getIntValue();
            if (((class_6880)e.getKey()).method_40220(class_9636.field_51551)) continue;
            i += enchantment.method_8182(j);
        }
        return i;
    }

    public void dropXP() {
        class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24953((class_2382)this.field_11867), (int)((int)Math.floor(this.expTank)));
    }

    private void updateResult() {
        class_1799 itemStack = this.method_5438(SLOT_ITEM_IN);
        class_1799 itemStack2 = this.method_5438(SLOT_ITEM_ADD);
        this.result = this.getOutputStack(itemStack, itemStack2, this.mode == MODE_DISENCHANT);
    }

    private class_1799 getOutputStack(class_1799 firstInput, class_1799 secondInput, boolean disenchant) {
        boolean bl;
        boolean bl2 = bl = !firstInput.method_7960() || !secondInput.method_7960();
        if (!bl) {
            return class_1799.field_8037;
        }
        if (firstInput.method_7947() <= 1 && secondInput.method_7947() <= 1) {
            boolean bl22;
            boolean bl3 = bl22 = !firstInput.method_7960() && !secondInput.method_7960();
            if (!bl22 && disenchant) {
                class_1799 itemStack = !firstInput.method_7960() ? firstInput : secondInput;
                return !class_1890.method_58117((class_1799)itemStack) ? class_1799.field_8037 : this.grind(itemStack.method_7972());
            }
            return this.combineItems(firstInput, secondInput);
        }
        return class_1799.field_8037;
    }

    private class_1799 transferEnchantments(class_1799 target, class_1799 source) {
        class_1890.method_57531((class_1799)target, components -> {
            class_9304 itemEnchantmentsComponent = class_1890.method_57532((class_1799)source);
            for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
                class_6880 enchantment = (class_6880)entry.getKey();
                if (enchantment.method_40220(class_9636.field_51551) && class_1890.method_8225((class_6880)enchantment, (class_1799)source) != 0) continue;
                components.method_57550(enchantment, entry.getIntValue());
            }
        });
        return target.method_7972();
    }

    private class_1799 combineItems(class_1799 firstInput, class_1799 secondInput) {
        class_1799 itemStack;
        if (!firstInput.method_31574(secondInput.method_7909())) {
            return class_1799.field_8037;
        }
        int i = Math.max(firstInput.method_7936(), secondInput.method_7936());
        int j = firstInput.method_7936() - firstInput.method_7919();
        int k = secondInput.method_7936() - secondInput.method_7919();
        int l = j + k + i * 5 / 100;
        int m = 1;
        if (!firstInput.method_7963()) {
            if (firstInput.method_7914() < 2 || !class_1799.method_7973((class_1799)firstInput, (class_1799)secondInput)) {
                return class_1799.field_8037;
            }
            m = 2;
        }
        if ((itemStack = firstInput.method_46651(m)).method_7963()) {
            itemStack.method_57379(class_9334.field_50072, (Object)i);
            itemStack.method_7974(Math.max(i - l, 0));
        }
        itemStack = this.transferEnchantments(itemStack, secondInput);
        return this.grind(itemStack);
    }

    private class_1799 grind(class_1799 item) {
        class_9304 itemEnchantmentsComponent = class_1890.method_57531((class_1799)item, components -> components.method_57548(enchantment -> !enchantment.method_40220(class_9636.field_51551)));
        if (item.method_31574(class_1802.field_8598) && itemEnchantmentsComponent.method_57543()) {
            item = item.method_56701((class_1935)class_1802.field_8529, item.method_7947());
        }
        int i = 0;
        for (int j = 0; j < itemEnchantmentsComponent.method_57541(); ++j) {
            i = class_1706.method_20398((int)i);
        }
        item.method_57379(class_9334.field_49639, (Object)i);
        return item;
    }
}

